﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class PromotionDB
    {
        public static Promotion GetItem(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            Promotion myPromo = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@StartDate", (startDate == DateTime.MinValue ? (object)DBNull.Value : startDate)));
            parameters.Add(new SqlParameter("@EndDate", (endDate == DateTime.MinValue ? (object)DBNull.Value : endDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myPromo = SQLHelper.RetrieveObject<Promotion>("spGetPromotion", parameters);
            myPromo.PromotionDetailsList = PromotionDetailsDB.GetList(Guid.Empty, myPromo.UniqueID, Guid.Empty, string.Empty);
            return myPromo;
        }

        public static List<Promotion> GetList(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            List<Promotion> myList = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@StartDate", (startDate == DateTime.MinValue ? (object)DBNull.Value : startDate)));
            parameters.Add(new SqlParameter("@EndDate", (endDate == DateTime.MinValue ? (object)DBNull.Value : endDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myList = SQLHelper.RetrieveList<Promotion>("spGetPromotion", parameters);

            foreach (Promotion currentTransaction in myList)
            {
                currentTransaction.PromotionDetailsList = PromotionDetailsDB.GetList(Guid.Empty, currentTransaction.UniqueID, Guid.Empty, string.Empty);
            }

            return myList;
        }

        public static DataTable GetDataTable(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@StartDate", (startDate == DateTime.MinValue ? (object)DBNull.Value : startDate)));
            parameters.Add(new SqlParameter("@EndDate", (endDate == DateTime.MinValue ? (object)DBNull.Value : endDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetPromotion", parameters);
        }

        public static DataSet GetDataSet(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@StartDate", (startDate == DateTime.MinValue ? (object)DBNull.Value : startDate)));
            parameters.Add(new SqlParameter("@EndDate", (endDate == DateTime.MinValue ? (object)DBNull.Value : endDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetPromotion", parameters);
        }

        public static void Save(Promotion myPromotion)
        {
            myPromotion.Mode = ((myPromotion.UniqueID != Guid.Empty && myPromotion.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myPromotion.UniqueID = ((myPromotion.UniqueID != Guid.Empty && myPromotion.UniqueID != null) ? myPromotion.UniqueID : Guid.NewGuid());
            if (myPromotion.Mode == GlobalConfigurations.Mode.Insert)
            {
                myPromotion.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionID", myPromotion.UniqueID));
            parameters.Add(new SqlParameter("@PromotionName", (string.IsNullOrEmpty(myPromotion.PromotionName) ? (object)DBNull.Value : myPromotion.PromotionName)));
            parameters.Add(new SqlParameter("@PromoType", (string.IsNullOrEmpty(myPromotion.PromoType) ? (object)DBNull.Value : myPromotion.PromoType)));
            parameters.Add(new SqlParameter("@StartDate", (myPromotion.StartDate == DateTime.MinValue) ? (object)DBNull.Value : myPromotion.StartDate));
            parameters.Add(new SqlParameter("@EndDate", (myPromotion.EndDate == DateTime.MinValue) ? (object)DBNull.Value : myPromotion.EndDate));
            parameters.Add(new SqlParameter("@OrderTotalFrom", (myPromotion.OrderTotalFrom == 0 ? (object)DBNull.Value : myPromotion.OrderTotalFrom)));
            parameters.Add(new SqlParameter("@OrderTotalTo", (myPromotion.OrderTotalTo == 0 ? (object)DBNull.Value : myPromotion.OrderTotalTo)));
            parameters.Add(new SqlParameter("@UseFromPrice", myPromotion.UseFromPrice));
            parameters.Add(new SqlParameter("@MaxUsage", (myPromotion.MaxUsage == 0) ? (object)DBNull.Value : myPromotion.MaxUsage));
            parameters.Add(new SqlParameter("@AvailableUsage", (myPromotion.AvailableUsage == 0) ? (object)DBNull.Value : myPromotion.AvailableUsage));
            parameters.Add(new SqlParameter("@CreatedBy", ((myPromotion.UserAccountID != Guid.Empty && myPromotion.UserAccountID != null) ? myPromotion.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myPromotion.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));

            SQLHelper.ExecuteQuery("spAddOrUpdatePromotion", parameters);
        }
    }
}
